function nm_init()
{
	svgdoc.getElementById("nm_header").firstChild.data = nm_invite
	for (var i = 0 ; i <= 18 ; i ++)
		svgdoc.getElementById("nm_interface" + i.toString()).firstChild.data = popup_message[13 + i]
	nm_name_map = nm_svg_file.substring(nm_svg_file.lastIndexOf("/") + 1 , nm_svg_file.indexOf("."))
	nm_root_map = nm_name_map
	svgdoc.getElementById("nm_name").firstChild.data = nm_name_map
	svgdoc.getElementById("nm_root").firstChild.data = nm_root_map
	getURL(nm_svg_file,nm_make_svg)
}

function nm_count()
{
	var j = -1
	var k = -1
	for (var i = 0 ; i < nm_nb_paths ; i ++)
		if (nm_selected[i] >= 0)
			if (svgdoc.getElementById("nm_p" + i.toString()).getAttribute("type") == "region")
				j += 1
			else
				k += 1
	svgdoc.getElementById("nm_nb_regions").firstChild.data = (j + 1).toString()
	svgdoc.getElementById("nm_nb_extras").firstChild.data = (k + 1).toString()
	nm_selected_region = -1
	svgdoc.getElementById("nm_region").firstChild.data = "?"
	svgdoc.getElementById("nm_txt_cursor").setAttribute("display" , "none")
}

function nm_convert_poly(nm_points)
{
	var nm_array_points = nm_points.split(" ")
	var str = "M"
	for (var k = 0 ; k < nm_array_points.length ; k ++)
		if (nm_array_points[k].indexOf(",") > 0)
		{
			var nm_array_point = nm_array_points[k].split(",")
			str += nm_array_point[0] + " " + nm_array_point[1] + " "
		}
	str += "z"
	return str
}

function nm_add_path(nm_node)
{
	switch(nm_node.nodeName)
	{
		case "path" :
			var nm_d = nm_node.getAttribute("d")
			break
		case "polygon" :
			var nm_d = nm_convert_poly(nm_node.getAttribute("points"))
			break
		case "polyline" :
			var nm_d = nm_convert_poly(nm_node.getAttribute("points"))
			break
		case "g" :
			var nodes_g = nm_node.childNodes
			for (var l = 0 ; l < nodes_g.length ; l ++)
				if (nodes_g.item(l).nodeType == 1)
					nm_add_path(nodes_g.item(l))
			break
	}
	var nm_paths="path;polygon;polyline"
	if ((nm_paths.indexOf(nm_node.nodeName) >= 0)&&(nm_node.nodeName != "g"))
	{
		nm_nb_paths += 1
		if (nm_node.getAttribute("id") != "")
			nm_names_regions[nm_nb_paths] = nm_node.getAttribute("id")
		else
			nm_names_regions[nm_nb_paths] = "?"
		var node_str = "<path id='nm_p" + nm_nb_paths.toString() + "' stroke-width='" + nm_ratio.toString()  + "' fill='white' fill-opacity='0.3' stroke='black' type='region' cursor='pointer'" 
		node_str += " d='" + nm_d + "'/>\n"
		var node = parseXML(node_str, svgdoc)
		svgdoc.getElementById("nm_map").appendChild(node)
		nm_selected[nm_nb_paths] = 0
	}
}

function nm_make_svg(data)
{
	if (!data.success)
	{
		alert("cannot load new map ...")
		return
	}
	if (data.content.indexOf("svg") > 0)
	{
		var str = data.content.substring(data.content.indexOf("svg") - 1 , data.content.length)
		var node = parseXML(str , svgdoc)
		svgdoc.getElementById("nm_tmp").appendChild(node)
		var node = svgdoc.getElementById("nm_tmp").firstChild
		while (node.nodeName != "svg")
			node = node.nextSibling
		nm_x = 0
		nm_y = 0
		nm_w = parseFloat(node.getAttribute("width"))
		nm_h = parseFloat(node.getAttribute("height"))
		if (node.getAttribute("viewBox") != "")
		{
			var nm_viewbox = node.getAttribute("viewBox")
			var nm_viewboxs = nm_viewbox.split(" ")
			nm_x = parseFloat(nm_viewboxs[0])
			nm_y = parseFloat(nm_viewboxs[1])
			nm_w = parseFloat(nm_viewboxs[2])
			nm_h = parseFloat(nm_viewboxs[3])
		}
		nm_ratio = Math.round(100 * Math.min(nm_w / 600, nm_h / 600)) / 100
		svgdoc.getElementById("nm_map").setAttribute("viewBox", nm_viewbox) 
		nm_nb_paths = -1
		nm_names_regions = new Array()
		nm_selected = new Array()
	
		var nodes = node.childNodes
		for (var j = 0 ; j < nodes.length ; j ++)
			if (nodes.item(j).nodeType == 1)
				nm_add_path(nodes.item(j))
		
		remove_window("nm_tmp")
		nm_nb_paths += 1
		nm_count()
	}
	else
		add_alert("svg/alert.svg","outil",dialog[20] +"\n" + dialog[21] + "\n" + dialog[22])

}

function nm_deselect()
{
	for (var i = 0 ; i < nm_nb_paths ; i ++)
		if (nm_selected[i] == 1)
		{
			nm_selected[i] = 0
			svgdoc.getElementById("nm_p" + i.toString()).setAttribute("stroke","black")
			svgdoc.getElementById("nm_p" + i.toString()).setAttribute("fill","white")
		}	
	svgdoc.getElementById("nm_region").firstChild.data = "?"
	svgdoc.getElementById("nm_txt_cursor").setAttribute("display" , "none")
	nm_selected_region = -1
}

function nm_remove()
{
	for (var i = 0 ; i < nm_nb_paths ; i ++)
		if (nm_selected[i] == 1)
		{
			nm_selected[i] = -1
			var node = svgdoc.getElementById("nm_p" + i.toString())
			svgdoc.getElementById("nm_map").removeChild(node)
		}	
	nm_count()
}

function nm_join(extra)
{
	var nm_d = ""
	var nm_num = -1
	for (var i = 0 ; i < nm_nb_paths ; i ++)
		if (nm_selected[i] == 1)
		{
			var str = svgdoc.getElementById("nm_p" + i.toString()).getAttribute("d")
			nm_d += str
			if (nm_num == -1)
				nm_num = i
			else
			{
				nm_selected[i] = -1
				var node = svgdoc.getElementById("nm_p" + i.toString())
				svgdoc.getElementById("nm_map").removeChild(node)
			}
		}	
	if (nm_num >= 0)
		svgdoc.getElementById("nm_p" + nm_num.toString()).setAttribute("d" , nm_d)
	if (extra)
	{
		nm_selected[nm_num] = -1
		svgdoc.getElementById("nm_p" + nm_num.toString()).setAttribute("type" , "extra")
		svgdoc.getElementById("nm_p" + nm_num.toString()).setAttribute("id" , "nm_p" + nm_nb_paths.toString())
		nm_selected[nm_nb_paths] = 1
		nm_nb_paths += 1
	}
	nm_count()
}

function nm_select(evt)
{
	var nm_cible = evt.target.getAttribute("id")
	var num = parseInt(nm_cible.substring(4,nm_cible.length),10)
	if (nm_selected[num] == 1)
	{
		nm_selected[num] = 0
		var nm_stroke = "black"
		var nm_fill = "white"
		svgdoc.getElementById("nm_region").firstChild.data = "?"
		svgdoc.getElementById("nm_txt_cursor").setAttribute("display" , "none")
		nm_selected_region = - 1
	}
	else
		if (nm_selected[num] == 0)
		{
			nm_selected[num] = 1
			var nm_stroke = "red"
			var nm_fill = "yellow"
			svgdoc.getElementById("nm_region").firstChild.data = nm_names_regions[num]
			svgdoc.getElementById("nm_txt_cursor").setAttribute("display" , "none")
			nm_selected_region = num
		}
	svgdoc.getElementById("nm_p" + num.toString()).setAttribute("stroke",nm_stroke)
	svgdoc.getElementById("nm_p" + num.toString()).setAttribute("fill",nm_fill)
}

function nm_reset()
{
	remove_window("nm_map")
	getURL(nm_svg_file,nm_make_svg)
}

function nm_refresh_data(cible , value)
{
	switch(cible)
	{
		case "nm_name" : 
			nm_name_map = value
			break
		case "nm_root" : 
			nm_root_map = value
			break
		case "nm_region" : 
			if (nm_selected_region >= 0)
				nm_names_regions[nm_selected_region] = value
			break
	}
}

function nm_edit_data(evt)
{
	var h_cur = 14
	if (ASV == "6")
	{
		var matrix = svgdoc.getElementById(prefixe_tool).getScreenCTM().inverse()
		nm_texte_node = evt.target
		var xm = parseFloat(evt.clientX * matrix.a + evt.clientY * matrix.c + matrix.e) - parseFloat(nm_texte_node.getAttribute("x"))
	}
	else
	{
		var matrix = svgdoc.getElementById(prefixe_tool).getScreenCTM().inverse()
		var xm = parseFloat(coordo_x(evt.clientX) * matrix.a + coordo_y(evt.clientY) * matrix.c + matrix.e) - parseFloat(evt.target.getAttribute("x"))
		nm_texte_node = evt.target
	}
	y_cur = parseFloat(nm_texte_node.getAttribute("y")) - 12
	x_cur = parseFloat(nm_texte_node.getAttribute("x")) 
	var str = nm_texte_node.firstChild.data
	if (xm > 0)
		nm_txt_pos = find_pos_txt(str , xm , prefixe_tool)
	else
		nm_txt_pos = 0
	svgdoc.rootElement.addEventListener("keydown",nm_txt_down,false)
	svgdoc.rootElement.addEventListener("keypress",nm_txt_tape,false)
	if (nm_txt_pos > 0)
	{
		var str_length = find_string_length(str.substring(0 , nm_txt_pos) , prefixe_tool)
		if (str.substring(nm_txt_pos - 1 , nm_txt_pos) == " ")
			str_length += h_cur * 0.2
	}
	else
		str_length = 0
	svgdoc.getElementById("nm_txt_cursor").setAttribute("d" , "M" + (x_cur + str_length).toString() + " " + y_cur.toString() + "v14")
	svgdoc.getElementById("nm_txt_cursor").setAttribute("display" , "inline")
}

function nm_txt_tape(evt)
{
	var largeur = 200
	var h_cur = 14
	var str = nm_texte_node.firstChild.data
	if (str == "?")
		str = ""
	var text_modified = false
	var add_space = false
	var key = evt.charCode
	switch(key)
	{	
		case 0 :
				break
		case 27:
				break
		case 13 :
				break
		case 8 :
				if (nm_txt_pos > 1)
					var debut = str.substring(0 , nm_txt_pos - 1)
				else
					var debut = ""
				if (nm_txt_pos < str.length)
					str = debut + str.substring(nm_txt_pos , str.length)
				else
					str = debut
				nm_txt_pos -= 1
				if (nm_txt_pos < 0)
					nm_txt_pos = 0
				text_modified = true
				nm_texte_node.firstChild.data = str
				break
		default :
				var max_str = false
				var caractere = String.fromCharCode(evt.charCode)
				str = str.substring(0 , nm_txt_pos) + caractere + str.substring(nm_txt_pos , str.length) 
				nm_texte_node.firstChild.data = str
				nm_txt_pos += 1
				if (find_string_length(str , prefixe_tool) > largeur)
				{
					str = str.substring(0 , str.length - 1)
					nm_txt_pos -= 1
					nm_texte_node.firstChild.data = str
				}
				else
					text_modified = true
				if (key == 32)
					if (str.substring(nm_txt_pos - 1, nm_txt_pos) == " ")
						add_space = true
					else
						nm_txt_pos -= 1
				break
	}
	if (!text_modified)
		return
	if (nm_txt_pos > 0)
	{
		var str_length = find_string_length(str.substring(0 , nm_txt_pos) , prefixe_tool)
		if (add_space)
			str_length += h_cur * 0.2
	}
	else
		var str_length = 0
	svgdoc.getElementById("nm_txt_cursor").setAttribute("d" , "M" + (x_cur + str_length).toString() + " " + y_cur.toString() + "v14")
	nm_refresh_data(nm_texte_node.getAttribute("id") , str)
}

function nm_txt_down(evt)
{
	var str = nm_texte_node.firstChild.data
	var h_cur = 14
	if (str == "?")
		str = ""
	var add_space = false
	var text_modified = false
	var key = evt.keyCode;
	switch(key)
	{	
		case 9 :
				break
		case 37 :
				nm_txt_pos -= 1
				if (nm_txt_pos < 0)
					nm_txt_pos = 0
				else
				{
					text_modified = true
					if (str.substring(nm_txt_pos - 1, nm_txt_pos) == " ")
						add_space = true
				}
				break
		case 39 :
				nm_txt_pos += 1
				if (nm_txt_pos > str.length)
					nm_txt_pos = str.length
				else
				{
					text_modified = true
					if (str.substring(nm_txt_pos - 1, nm_txt_pos) == " ")
						add_space = true
				}
				break
		case 127 :
				if (nm_txt_pos < str.length)
				{
					str = str.substring(0 , nm_txt_pos) + str.substring(nm_txt_pos + 1, str.length)
					nm_texte_node.firstChild.data = str
					text_modified = true
				}
				break
		default :
				break
	}
	if (!text_modified)
		return
	if (nm_txt_pos > 0)
	{
		var str_length = find_string_length(str.substring(0 , nm_txt_pos) , prefixe_tool)
		if (add_space)
			str_length += h_cur * 0.2
	}
	else
		var str_length = 0
	svgdoc.getElementById("nm_txt_cursor").setAttribute("d" , "M" + (x_cur + str_length).toString() + " " + y_cur.toString() + "v14")
	nm_refresh_data(nm_texte_node.getAttribute("id") , str)
}

